/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SortedLists {
    private SortedLists() {
    }

    public static <E> int binarySearch(List<? extends E> list, @Nullable E e, Comparator<? super E> comparator, Relation relation) {
        return SortedLists.binarySearch(list, e, comparator, relation, true);
    }

    static <E> int binarySearch(List<? extends E> list, @Nullable E e, Comparator<? super E> comparator, Relation relation, boolean bl) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(relation);
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = comparator.compare(e, list.get(n3));
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return relation.exactMatchFound(list, e, n, n3, n2, comparator, bl);
        }
        return relation.exactMatchNotFound(list, e, n, comparator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Relation {
        LOWER{

            @Override
            public Relation reverse() {
                return HIGHER;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int n, int n2, int n3, Comparator<? super E> comparator, boolean bl) {
                return FLOOR.exactMatchFound(list, e, n, n2, n3, comparator, bl) - 1;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int n, Comparator<? super E> comparator) {
                return n - 1;
            }
        }
        ,
        FLOOR{

            @Override
            public Relation reverse() {
                return CEILING;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int n, int n2, int n3, Comparator<? super E> comparator, boolean bl) {
                if (!bl) {
                    return n2;
                }
                n3 = n2;
                while (n < n3) {
                    int n4 = n + (n3 - n) / 2;
                    int n5 = comparator.compare(list.get(n4), e);
                    if (n5 < 0) {
                        n = n4 + 1;
                        continue;
                    }
                    n3 = n4;
                }
                return n;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int n, Comparator<? super E> comparator) {
                return n - 1;
            }
        }
        ,
        EQUAL{

            @Override
            public Relation reverse() {
                return this;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int n, int n2, int n3, Comparator<? super E> comparator, boolean bl) {
                return n2;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int n, Comparator<? super E> comparator) {
                return -1;
            }
        }
        ,
        CEILING{

            @Override
            public Relation reverse() {
                return FLOOR;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int n, int n2, int n3, Comparator<? super E> comparator, boolean bl) {
                if (!bl) {
                    return n2;
                }
                n = n2;
                while (n < n3) {
                    int n4 = n + (n3 - n + 1) / 2;
                    int n5 = comparator.compare(list.get(n4), e);
                    if (n5 > 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    n = n4;
                }
                return n;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int n, Comparator<? super E> comparator) {
                return n;
            }
        }
        ,
        HIGHER{

            @Override
            public Relation reverse() {
                return LOWER;
            }

            @Override
            <E> int exactMatchFound(List<? extends E> list, E e, int n, int n2, int n3, Comparator<? super E> comparator, boolean bl) {
                return CEILING.exactMatchFound(list, e, n, n2, n3, comparator, bl) + 1;
            }

            @Override
            <E> int exactMatchNotFound(List<? extends E> list, E e, int n, Comparator<? super E> comparator) {
                return n;
            }
        };


        public abstract Relation reverse();

        abstract <E> int exactMatchFound(List<? extends E> var1, @Nullable E var2, int var3, int var4, int var5, Comparator<? super E> var6, boolean var7);

        abstract <E> int exactMatchNotFound(List<? extends E> var1, @Nullable E var2, int var3, Comparator<? super E> var4);
    }
}

